#!/bin/sh

MASTER_PAGE_SC_STATUS_RESULT_MSG=""
MASTER_PAGE_SC_STATUS_RESULT_OK=0
MASTER_PAGE_SC_STATUS_RESULT_ERROR=1

MASTER_PAGE_SC_STATUS_RESULT_CODE=${MASTER_PAGE_SC_STATUS_RESULT_ERROR}
MASTER_PAGE_SC_STATUS_RESULT_ROLLING=0

master_page_sc_status() {
	debug_print "${0}" "${LINENO}" 'in function "master_page_sc_status"'
	
    filename="/tmp/"`uuidgen`;

    php $CONS_BACKEND get_sandbox_controller_info "${DTASCFG_XML_FILE}" > $filename

	echo $filename
	
    if [ -e $filename ]; then
		tp_msg_ok \
			"${MASTER_PAGE_SC_STATUS_TITLE}" \
			"`cat $filename`" \
			"${MASTER_PAGE_SC_STATUS_LABEL_OK}"
    else
        dialog --msgbox "*** ERROR ***\n$filename does not exist" "${box_height}" "${box_width}"
    fi
	
	MASTER_PAGE_SC_STATUS_RESULT_CODE=${MASTER_PAGE_SC_STATUS_RESULT_OK}
	MASTER_PAGE_SC_STATUS_RESULT_ROLLING=-1
	
    rm -f "${filename}"
}